#pragma once
#include "global.h"
#include "simpleini.h"


typedef struct IniFileEntry
{
	//debug output
	bool bShowDebugInfo;

	//automatic frame skip method
	bool bAutomaticFrameSkip;

	//manual frame skip method (throttlespeed)
	bool bManualFrameSkip;

	//number of frames to skip
	DWORD dwNumFrameSkips;

	//sync audio to video
	bool bSyncAudioToVideo;

	//vertical synchronization
	bool bVSync;

	//flicker filter
	DWORD dwFlickerFilter;

	//soft display filter
	bool bSoftDisplayFilter;

	//texture filter
	DWORD dwTextureFilter;

	//screen xpos
	int iXPOS;
	//screen ypos
	int iYPOS;
	//screen xscale
	int iXWIDTH;
	//screen yscale
	int iYHEIGHT;

	//hide normal scroll 0
	bool bHideNBG0;
	//hide normal scroll 1
	bool bHideNBG1;
	//hide normal scroll 2
	bool bHideNBG2;
	//hide normal scroll 3
	bool bHideNBG3;
	//hide rotation scroll 0
	bool bHideRBG0;
	//hide VDP1
	bool bHideVDP1;

	//resolution
	int iResolution;
	
}IniFileEntry;


class IniFile
{
public:
	IniFile(void);
	~IniFile(void);

	bool Save(const string &szIniFileName);
	bool Load(const string &szIniFileName);
	bool LoadTempRomFileName();
	bool CreateAndSaveDefaultIniEntry();
	bool CheckForIniEntry();

	IniFileEntry m_currentIniEntry;
	string szTempRomFileName;
	string szTempRomIniFileName;
	string m_szTempSystemDir;

private:
	IniFileEntry m_defaultIniEntry;
	
	
};

extern IniFile g_iniFile;





